<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Community extends Model 
{

    protected $table = 'communities';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_ar', 'name_en', 'is_active', 'district_id');

    public function buildings()
    {
        return $this->morphMany('Building', 'model');
    }

    public function units()
    {
        return $this->morphMany('Unit', 'model');
    }

    public function location()
    {
        return $this->morphOne('Location', 'model');
    }

    public function district()
    {
        return $this->belongsTo('District');
    }

    public function files()
    {
        return $this->morphMany('File', 'model');
    }

}